/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "myriexpress.h"
#include "test_common.h"

static void test_params(void);
static void test_nic_count(void);
static void test_nic_ids(void);
static void test_max_native_endpoints(void);
static void test_native_requests(void);
static void test_counters(void);
static void test_product_code(void);
static void test_part_number(void);
static void test_serial_number(void);
static void test_port_count(void);

int
main (void)
{
  mx_set_error_handler(MX_ERRORS_RETURN);
  mx_init();
  test_params();
  test_nic_count();
  test_nic_ids();
  test_max_native_endpoints();
  test_native_requests();
  test_counters();
  test_product_code();
  test_part_number();
  test_serial_number();
  test_port_count();
  mx_finalize();
  printf("[PASS]\n");
  fflush(stdout);
  return 0;
}

static void test_params(void)
{
  mx_return_t r;
  
  /* bad key bad */
  r = mx_get_info(NULL, -1, NULL, 0, &r, sizeof (r));
  insist(r == MX_BAD_INFO_KEY);
  
  /* NULL val bad */
  r = mx_get_info(NULL, MX_NIC_COUNT, NULL, 0, NULL, sizeof (r));
  insist(r == MX_BAD_INFO_VAL);

  /* both bad key and NULL val, either error ok */
  r = mx_get_info(NULL, -1, NULL, 0, NULL, sizeof (r));
  insist((r == MX_BAD_INFO_KEY) ||
	 (r == MX_BAD_INFO_VAL));
}

static void test_nic_count(void)
{
  mx_return_t r;
  uint32_t tmp;

  /* correct invocation */
  r = mx_get_info(NULL, MX_NIC_COUNT, NULL, 0, &tmp, sizeof (tmp));
  insist(r == MX_SUCCESS);

  /* size too small bad */
  r = mx_get_info(NULL, MX_NIC_COUNT, NULL, 0, &tmp, sizeof (tmp)-1);
  insist(r == MX_BAD_INFO_LENGTH);

  /* larger size ok */
  r = mx_get_info(NULL, MX_NIC_COUNT, NULL, 0, &tmp, sizeof (tmp)+1);
  insist(r == MX_SUCCESS);

  printf("%d\n", tmp);
}

static void test_nic_ids(void)
{
  mx_return_t r;
  uint32_t tmp;
  uint64_t *p;
  uint32_t i;

  r = mx_get_info(NULL, MX_NIC_COUNT, NULL, 0, &tmp, sizeof (tmp));
  insist(r == MX_SUCCESS);

  p = malloc((tmp+1) * sizeof (*p));
  insist(p != NULL);

  /* correct invocation */
  r = mx_get_info(NULL, MX_NIC_IDS, NULL, 0, p, (tmp+1) * sizeof (*p));
  insist(r == MX_SUCCESS);

  /* size too small bad */
  r = mx_get_info(NULL, MX_NIC_IDS, NULL, 0, p, (tmp+1) * sizeof (*p) - 1);
  insist(r == MX_BAD_INFO_LENGTH);

  /* size too large ok */
  r = mx_get_info(NULL, MX_NIC_IDS, NULL, 0, p, (tmp+1) * sizeof (*p) + 1);
  insist(r == MX_SUCCESS);

  for(i = 0; i < tmp+1; ++i) {
    printf("%"PRIx64"\n", p[i]);
  }

  free(p);
}

static void test_max_native_endpoints(void)
{
  mx_return_t r;
  uint32_t tmp;

  /* correct invocation */
  r = mx_get_info(NULL, MX_MAX_NATIVE_ENDPOINTS, NULL, 0, &tmp, sizeof (tmp));
  insist(r == MX_SUCCESS);

  /* size too small bad */
  r = mx_get_info(NULL, MX_MAX_NATIVE_ENDPOINTS, NULL, 0, &tmp, sizeof (tmp)-1);
  insist(r == MX_BAD_INFO_LENGTH);

  /* larger size ok */
  r = mx_get_info(NULL, MX_MAX_NATIVE_ENDPOINTS, NULL, 0, &tmp, sizeof (tmp)+1);
  insist(r == MX_SUCCESS);

  printf("%d\n", tmp);
}

static void test_native_requests(void)
{
  mx_return_t r;
  uint32_t tmp;

  /* correct invocation */
  r = mx_get_info(NULL, MX_NATIVE_REQUESTS, NULL, 0, &tmp, sizeof (tmp));
  insist(r == MX_SUCCESS);

  /* size too small bad */
  r = mx_get_info(NULL, MX_NATIVE_REQUESTS, NULL, 0, &tmp, sizeof (tmp)-1);
  insist(r == MX_BAD_INFO_LENGTH);

  /* larger size ok */
  r = mx_get_info(NULL, MX_NATIVE_REQUESTS, NULL, 0, &tmp, sizeof (tmp)+1);
  insist(r == MX_SUCCESS);

  printf("%d\n", tmp);
}

static void test_counters(void)
{
  mx_return_t r;
  uint32_t board_id;
  uint32_t count;
  uint8_t *labels;
  uint32_t i;
  uint32_t *values;

  board_id = 0;
  r = mx_get_info(NULL, MX_COUNTERS_COUNT, &board_id, sizeof (board_id),
		  &count, sizeof (count));
  labels = malloc (count * MX_MAX_STR_LEN);
  r = mx_get_info(NULL, MX_COUNTERS_LABELS, &board_id, sizeof (board_id),
		  labels, count * MX_MAX_STR_LEN);
  for (i = 0; i < count; ++i) {
    printf("%s\n", &labels[i * MX_MAX_STR_LEN]);
  }
  values = malloc (count * sizeof (uint32_t));
  r = mx_get_info(NULL, MX_COUNTERS_VALUES, &board_id, sizeof (board_id),
		  values, count * sizeof (uint32_t));
  for (i = 0; i < count; ++i) {
    printf("%x\n", values[i]);
  }
}

static void test_product_code(void)
{
  mx_return_t r;
  uint32_t board_id;
  uint8_t str[MX_MAX_STR_LEN];

  board_id = 0;
  r = mx_get_info(NULL, MX_PRODUCT_CODE, &board_id, sizeof (board_id),
		  str, sizeof (str));
  printf("%s\n", str);
}

static void test_part_number(void)
{
  mx_return_t r;
  uint32_t board_id;
  uint8_t str[MX_MAX_STR_LEN];

  board_id = 0;
  r = mx_get_info(NULL, MX_PART_NUMBER, &board_id, sizeof (board_id),
		  str, sizeof (str));
  printf("%s\n", str);
}

static void test_serial_number(void)
{
  mx_return_t r;
  uint32_t board_id;
  uint32_t serial_number;

  board_id = 0;
  r = mx_get_info(NULL, MX_SERIAL_NUMBER, &board_id, sizeof (board_id),
		  &serial_number, sizeof (serial_number));
  printf("%u\n", serial_number);

}

static void test_port_count(void)
{
  mx_return_t r;
  uint32_t board_id;
  uint32_t port_count;

  board_id = 0;
  r = mx_get_info(NULL, MX_PORT_COUNT, &board_id, sizeof (board_id),
		  &port_count, sizeof (port_count));
  printf("%u\n", port_count);

}
